<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (!isset($_GET['cours_id']) || !isset($_GET['note_id'])) {
    header("Location: notes.php");
}

$cours_id = $_GET['cours_id'];
$note_id = $_GET['note_id'];

$requete = $bdd->prepare("SELECT nom, nom_cours FROM cours, groupe WHERE id_cours=:id AND groupe.id=cours.id_groupe2");
$requete->bindParam(':id', $cours_id);
$requete->execute();
$nom = $requete->fetch();

if (!$nom) {
    header("Location: notes.php");
}

$requete2 = $bdd->prepare("SELECT id_note_cours, type_note, coefficient, eleve.nom, prenom, id_eleve FROM eleve, cours, groupe_eleve, groupe, coefficient WHERE eleve.id_eleve=groupe_eleve.id_eleve4 AND groupe_eleve.id_groupe=groupe.id AND groupe_eleve.id_eleve4=eleve.id_eleve AND groupe_eleve.id_groupe=cours.id_groupe2 AND coefficient.id_cours3=cours.id_cours AND cours.id_cours=:id AND id_note_cours=:id_note_cours");
$requete2->bindParam(':id', $cours_id);
$requete2->bindParam(':id_note_cours', $note_id);
$requete2->execute();

if ($requete2->rowCount() == 0) {
    die('Vous ne pouvez pas rajouter de note à un cours sans élève');
}

$note = $requete2->fetch();

// TODO: duplication
$requete3 = $bdd->prepare("SELECT id_note_cours, type_note, coefficient, eleve.nom, prenom, id_eleve FROM eleve, cours, groupe_eleve, groupe, coefficient WHERE eleve.id_eleve=groupe_eleve.id_eleve4 AND groupe_eleve.id_groupe=groupe.id AND groupe_eleve.id_eleve4=eleve.id_eleve AND groupe_eleve.id_groupe=cours.id_groupe2 AND coefficient.id_cours3=cours.id_cours AND cours.id_cours=:id AND id_note_cours=:id_note_cours");
$requete3->bindParam(':id', $cours_id);
$requete3->bindParam(':id_note_cours', $note_id);
$requete3->execute();

if (isset($_POST['note']) && ($_POST['note'] < 0 || $_POST['note'] > 20)) {
    die('Note invalide');
}

if (isset($_POST['note']) && isset($_POST['eleve'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare('INSERT INTO note (eleve_id, note_id, note) VALUES (:eleve, :note_id, :note)');
        $requete->bindParam(':eleve', $_POST['eleve']);
        $requete->bindParam(':note_id', $note_id);
        $requete->bindParam(':note', $_POST['note']);
        $requete->execute();

        $bdd->commit();

        header('Location: notes.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }

}
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Ajouter une note </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Cours</label>
                                    <input id="disabledInput" class="form-control" type="text" disabled="" placeholder="<?php echo htmlspecialchars($nom['nom'].' > '.$nom['nom_cours']); ?>">
                                    <label>Note</label>
                                    <input id="disabledInput" class="form-control" type="text" disabled="" placeholder="<?php echo htmlspecialchars($note['type_note'].' : '.$note['coefficient']); ?>">
                                    <label>Élève</label>
                                    <select class="form-control" name="eleve">
                                        <option value="">Aucun</option>
                                        <?php
                                        while ( $row = $requete3->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id_eleve']).'">'.htmlspecialchars($row['prenom'].' '.$row['nom']).'</option>';
                                        ?>
                                    </select>
                                    <label>Note</label>
                                    <input class="form-control" name="note">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
